def delete_lines(file_name1, file_name2, start_line, end_line):
    # 一時的に内容を保存するリストを作成
    lines = []
    
    # ファイルを読み込む
    with open(file_name1, 'r', encoding='utf-8') as file:
        lines = file.readlines()

    # 指定範囲の行を削除
    if 0 <= start_line <= end_line < len(lines):
        del lines[start_line-1:end_line]
    else:
        print(f"範囲 {start_line} から {end_line} は範囲外です。")

    # ファイルに内容を書き戻す
    with open(file_name2, 'w', encoding='utf-8') as file:
        file.writelines(lines)

def embed_text(file_name, insert_line, embed_file_name):
    # メインファイルを読み込む
    with open(file_name, 'r', encoding='utf-8') as main_file:
        main_lines = main_file.readlines()

    # 埋め込みファイルを読み込む
    with open(embed_file_name, 'r', encoding='utf-8') as embed_file:
        embed_lines = embed_file.readlines()

    # 指定行に埋め込みファイルの内容を挿入
    if 0 <= insert_line <= len(main_lines):
        new_lines = main_lines[:insert_line] + embed_lines + main_lines[insert_line:]
    else:
        print(f"行番号 {insert_line} は範囲外です。")
        return

    # 更新された内容を元のファイルに書き戻す
    with open(file_name, 'w', encoding='utf-8') as main_file:
        main_file.writelines(new_lines)


file_name1 = 'mmc_stm32f1_spi.c'
file_name2 = 'mmc_pico_spi.c'
file_name3 = 'pico_chg.c'
start_line_to_delete = 14  # 削除を開始する行番号（0から開始）
end_line_to_delete = 208    # 削除を終了する行番号（0から開始）
delete_lines(file_name1, file_name2, start_line_to_delete, end_line_to_delete)

embed_text(file_name2, 14, file_name3)