#include "pico/stdlib.h"
#include "hardware/spi.h"

/*
   GPIO 16 (pin 21) MISO/spi0_rx-> SDO
   GPIO 17 (pin 22) Chip select -> !CS
   GPIO 18 (pin 24) SCK/spi0_sclk -> SCK
   GPIO 19 (pin 25) MOSI/spi0_tx -> SDI
*/
#define DEF_SPI_TX_PIN	19
#define DEF_SPI_RX_PIN	16
#define DEF_SPI_SCK_PIN	18
#define DEF_SPI_CSN_PIN	17

#define SPIDEV		spi0

#define FCLK_FAST()	{ }
#define FCLK_SLOW()	{ }

#define CS_HIGH()	{ gpio_put( DEF_SPI_CSN_PIN, 1 ); /* HIGH */ }
#define CS_LOW()	{ gpio_put(DEF_SPI_CSN_PIN , 0 ); /* LOW */ }

#define	MMC_CD		1 /* Card detect (yes:true, no:false, default:true) */
#define	MMC_WP		0 /* Write protected (yes:true, no:false, default:false) */


volatile  int  conter1;

void  Delay( int ms )
{
  for( conter1=0; conter1<125*ms ; conter1++ ) ;
}


/*--------------------------------------------------------------------------

   Module Private Functions

---------------------------------------------------------------------------*/
#include "ff.h"			/* Obtains integer types */
#include "diskio.h"		/* Declarations of disk functions */


/* MMC card type flags (MMC_GET_TYPE) */
#define CT_MMC3		0x01		/* MMC ver 3 */
#define CT_MMC4		0x02		/* MMC ver 4+ */
#define CT_MMC		0x03		/* MMC */
#define CT_SDC1		0x02		/* SDC ver 1 */
#define CT_SDC2		0x04		/* SDC ver 2+ */
#define CT_SDC		0x0C		/* SDC */
#define CT_BLOCK	0x10		/* Block addressing */


/* MMC/SD command */
#define CMD0	(0)			/* GO_IDLE_STATE */
#define CMD1	(1)			/* SEND_OP_COND (MMC) */
#define	ACMD41	(0x80+41)	/* SEND_OP_COND (SDC) */
#define CMD8	(8)			/* SEND_IF_COND */
#define CMD9	(9)			/* SEND_CSD */
#define CMD10	(10)		/* SEND_CID */
#define CMD12	(12)		/* STOP_TRANSMISSION */
#define ACMD13	(0x80+13)	/* SD_STATUS (SDC) */
#define CMD16	(16)		/* SET_BLOCKLEN */
#define CMD17	(17)		/* READ_SINGLE_BLOCK */
#define CMD18	(18)		/* READ_MULTIPLE_BLOCK */
#define CMD23	(23)		/* SET_BLOCK_COUNT (MMC) */
#define	ACMD23	(0x80+23)	/* SET_WR_BLK_ERASE_COUNT (SDC) */
#define CMD24	(24)		/* WRITE_BLOCK */
#define CMD25	(25)		/* WRITE_MULTIPLE_BLOCK */
#define CMD32	(32)		/* ERASE_ER_BLK_START */
#define CMD33	(33)		/* ERASE_ER_BLK_END */
#define CMD38	(38)		/* ERASE */
#define CMD55	(55)		/* APP_CMD */
#define CMD58	(58)		/* READ_OCR */


static volatile DSTATUS Stat = STA_NOINIT;	/* Physical drive status */
static volatile UINT Timer1, Timer2;		/* 1kHz decrement timer stopped at zero (disk_timerproc()) */

static BYTE CardType;	/* Card type flags */



/*-----------------------------------------------------------------------*/
/* SPI controls (Platform dependent)                                     */
/*-----------------------------------------------------------------------*/

/* Initialize MMC interface */
static void init_spi (void)
{
	spi_init( SPIDEV, 5 * 1000 * 1000 ); /* 5Mbps */
	gpio_set_function( DEF_SPI_TX_PIN, GPIO_FUNC_SPI );
	gpio_set_function( DEF_SPI_RX_PIN, GPIO_FUNC_SPI );
	gpio_set_function( DEF_SPI_SCK_PIN, GPIO_FUNC_SPI );

	/* CS# */
	gpio_init( DEF_SPI_CSN_PIN );
	gpio_set_dir( DEF_SPI_CSN_PIN, GPIO_OUT);

	CS_HIGH();            /* Set CS# high */

#if 0
	for (Timer1 = 10; Timer1; ) ;	/* 10ms */
#else
	Delay( 10 );
#endif
}


/* Exchange a byte */
static BYTE xchg_spi (
	BYTE dat	/* Data to send */
)
{
	uint8_t  src, dst;

	src = dat;
	spi_write_read_blocking( SPIDEV, &src, &dst, 1 );
	return  (BYTE)dst;
}


/* Receive multiple byte */
static void rcvr_spi_multi (
	BYTE *buff,		/* Pointer to data buffer */
	UINT btr		/* Number of bytes to receive (even number) */
)
{

	spi_read_blocking( SPIDEV, 0xff, buff, btr );
}


/* Send multiple byte */
static void xmit_spi_multi (
	const BYTE *buff,	/* Pointer to the data */
	UINT btx			/* Number of bytes to send (even number) */
)
{
	spi_write_blocking( SPIDEV, buff, btx );
}
